package rs.co.master.dao;


import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import rs.co.master.bean.UserBean;


@Repository
@Configuration
@Service("UserDetailService")
@Transactional(readOnly=true)
public class SimpleUserDetailsService implements UserDetailsService {
	
	@Autowired
	private UserDao userDAO;

	private UserBean domainUser; 

	
	public SimpleUserDetailsService() {
		super();
		// TODO Auto-generated constructor stub
	}

	public UserDetails loadUserByUsername(String login)
			throws UsernameNotFoundException {
		domainUser = userDAO.getUser(login);
		
		boolean enabled = true;
		boolean disabled = false;
		boolean accountNonExpired = true;
		boolean accountExpired = false;
		boolean credentialsNonExpired = true;
		boolean credentialsExpired = false;
		boolean accountNonLocked = true;
		boolean accountLocked = false;

		if (null != domainUser){
		return new User(
				domainUser.getUsername(), //getLogin(), 
				domainUser.getPassword(), 
				enabled, 
				accountNonExpired, 
				credentialsNonExpired, 
				accountNonLocked,
				getAuthorities(domainUser.getIduser() ) );
		
		} else {
			return new User(
					null, 
					null, 
					disabled, 
					accountExpired, 
					credentialsExpired, 
					accountLocked,
					null) ;
		}
		
	}
	
	
	public Collection<? extends GrantedAuthority> getAuthorities(Integer userid) {
		List<GrantedAuthority> authList = getGrantedAuthorities(getRoles(userid));
		return authList;
	}
	
	public List<String> getRoles(Integer userid) {

		List<String> roles = new ArrayList<String>();
		roles = userDAO.getUserRoles(userid);
		
		return roles;
	}
	
	public static List<GrantedAuthority> getGrantedAuthorities(List<String> roles) {
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		
		for (String role : roles) {
			authorities.add(new SimpleGrantedAuthority(role));
		}
		return authorities;
	}

}
