/**
 * @author Misko 30.05.2013
 * 
 * 
 */

package rs.co.master.dao;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

import rs.co.master.bean.UserBean;
import rs.co.master.service.UserRulesService;


@Component
@Repository("UserDaoR")
@Transactional
@EnableTransactionManagement 
public class UserDaoImpl implements UserDao {
	private Integer pageNo;
	private Integer pageSize;
	private Integer total;
	private String sortname;
	private String sortorder;
	private String querySearch;
	private String queryQType;

	private String jsonPage;
	
	private Md5PasswordEncoder passwordEncoder = new Md5PasswordEncoder();
		
	@Autowired
	private SessionFactory sessionFactory;


	@Autowired
	private UserRulesService userRulesService;
	

	public UserDaoImpl() {
		super();
		// TODO Auto-generated constructor stub
	}

	public UserDaoImpl(SessionFactory sessionFactory2) {
		this.sessionFactory = sessionFactory2;
	}

	public SessionFactory getSessionFactory() {
		return sessionFactory;
	}

	public void setSessionFactory(SessionFactory sessionFactory) {
		this.sessionFactory = sessionFactory;
	}

	public static String getTimeSeparator(Locale locale) {
		String sepValue = ":";

		DateFormat dateFormatter = DateFormat.getTimeInstance(DateFormat.SHORT,
				locale);
		DateFormatSymbols dfs = new DateFormatSymbols(locale);
		Date now = new Date();

		String[] amPmStrings = dfs.getAmPmStrings();
		String localeTime = dateFormatter.format(now);
		// remove the am pm string if they exist
		for (int i = 0; i < amPmStrings.length; i++) {
			localeTime = localeTime.replace(dfs.getAmPmStrings()[i], "");
		}

		// search for the character that isn't a digit.
		for (int currentIndex = 0; currentIndex < localeTime.length(); currentIndex++) {
			if (!(Character.isDigit(localeTime.charAt(currentIndex)))) {
				sepValue = localeTime.substring(currentIndex, currentIndex + 1);
				break;
			}
		}

		return sepValue;
	}


	@SuppressWarnings("unchecked")
	public List<UserBean> listUser() {

		List<UserBean> csModel;

		String hql = "from UserModel " + " order by username ";
		Query query = sessionFactory.getCurrentSession().createQuery(hql)
				.setResultTransformer(Transformers
						.aliasToBean(UserBean.class));

		csModel = (List<UserBean>) query.list();

		return csModel;
	}

	@SuppressWarnings("rawtypes")
	public List getSveUserove() throws Exception {
		String hql = "from UserModel";
		Query query = sessionFactory.getCurrentSession().createQuery(hql);
		return query.list();
	}



	@Transactional
	public void addUser(UserBean utente)  throws Exception{
		try {

			UserModel u = new UserModel();
			if (null == utente.getIduser() || (utente.getStari_password() == null || utente.getPassword().compareTo(utente.getStari_password()) != 0)){
				//passwordEncoder.setEncodeHashAsBase64(false);
				//String newPass;
				utente.setPassword(passwordEncoder.encodePassword(utente.getPassword(), null));
			}
			
			u = new UserModel();//convertToModel(utente);
			sessionFactory.getCurrentSession().saveOrUpdate(u);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		} 

	}
	public void deleteUser(Integer iduser) {
		sessionFactory
				.getCurrentSession()
				.createQuery(
						"DELETE FROM UserModel WHERE iduser =:iduser "
								)
					.setInteger("iduser", iduser)
					.executeUpdate();
	}


	public UserBean getUser(Integer iduser) {
		if ((iduser == null ))
			return null;

		UserBean tmpUser = null;

		String sql = "SELECT t.iduser as iduser, t.username as username, "
				+ " t.password as Password, "
				+ " t.accountNonExpired as accountNonExpired, t.accountNonLocked as accountNonLocked, "
				+ " t.credentialsNonExpired as credentialsNonExpired, t.enabled as enabled, "
				+ " t.mobilni as mobilni, t.adresa as adresa, t.telefon as telefon, "
				+ " t.email as email, "
				+ " t.ime as ime, t.prezime as prezime, "
				+ " t.isuseradmin as isuseradmin, t.isvlasnik as isvlasnik"

				+ " from user t where iduser = :iduser ";
		try {
			
			tmpUser = (UserBean) sessionFactory.getCurrentSession()
					.createSQLQuery(sql).setInteger("iduser", iduser)
					.setResultTransformer(Transformers
					.aliasToBean(UserBean.class))
					.uniqueResult();
			if (null == tmpUser) {
				tmpUser = new UserBean();
			}
			tmpUser.setStari_password(tmpUser.getPassword());
			
		} catch (Exception e) {
			// log.error("Error occurred while getting tasks by project iduser : "+e.getMessage());
			e.printStackTrace();
			tmpUser = new UserBean();
		}
		return tmpUser;

	}

	public UserBean findUser(String username) {
		if (username == null)
			return null;

		UserBean tmpUser = null;

		String sql = "from UserModel  where username = :username ";
		try {
			tmpUser = (UserBean) sessionFactory.getCurrentSession()
					.createQuery(sql)
					.setString("username", username)
					.setResultTransformer(Transformers
					.aliasToBean(UserBean.class))
					.uniqueResult();

			if (null == tmpUser) {
				return null;//tmpUser = new User();
			}
		} catch (Exception e) {
			// log.error("Error occurred while getting tasks by project iduser : "+e.getMessage());
			e.printStackTrace();
			tmpUser = new UserBean();
		}
		return tmpUser;

	}
	public Boolean isAdmin(Integer iduser){
		
/* ovo mi ne treba jer ima u principal*/
		String sql = "SELECT count(iduser) iduser FROM roles r "
				+ "inner join user_roles ru "
				+ "    on ru.role_id = r.id "
				+ " join user u "
				+ "   on u.iduser = ru.user_id "
				+ " WHERE (role = 'ROLE_ADMIN' or  role='ROLE_SUPERADMIN') and  iduser = :iduser ";
		try {
			BigInteger ima = (BigInteger) sessionFactory.getCurrentSession()
					.createSQLQuery(sql)
					.setInteger("iduser", iduser)
					.uniqueResult();

			if (null == ima) {
				return false;
			}
			if (ima.compareTo(BigInteger.ZERO) > 0){
				return true;
			}	
		} catch (Exception e) {
			// log.error("Error occurred while getting tasks by project iduser : "+e.getMessage());
			e.printStackTrace();
		}
		return false;
	}

	public boolean hasUser(Integer iduser) {
		Integer tmp;
		Boolean result = false;
		/* ne koristi se */

		String sql = "select count(cm.iduser) as iduser from User cm where cm.iduser=:iduser";
		try {
			tmp = (Integer) sessionFactory.getCurrentSession().createQuery(sql)
					.setInteger("iduser", iduser).uniqueResult();
			if (tmp > 0) {
				result = true;
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;

	}


@Override
public UserBean getUser(String login) {
	
		String sql = "SELECT t.iduser as iduser, t.username as username, "
				+ " t.password as Password, "
				+ " t.accountNonExpired as accountNonExpired, t.accountNonLocked as accountNonLocked, "
				+ " t.credentialsNonExpired as credentialsNonExpired, t.enabled as enabled, "
				+ " t.mobilni as mobilni, t.adresa as adresa, t.telefon as telefon, "
				+ " t.email as email, "
				+ " t.ime as ime, t.prezime as prezime, "
				+ " t.isuseradmin as isuseradmin, t.isvlasnik as isvlasnik "
				+ " from UserModel t where upper(t.username) = upper(:login) ";

		try{
			Query query = sessionFactory
							.getCurrentSession().createQuery(
								sql)
							.setString("login", login)
							.setResultTransformer(Transformers.aliasToBean(UserBean.class))
							;

			UserBean user =  (UserBean) query.uniqueResult();
 		if (null != user)
 			return user;
 		else return null;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}	
		/*
		
		
		List<User> userList = new ArrayList<User>();

		String sql = "select new User() from User u where upper(u.username) = upper(:login) ";
		try{
			Query query = sessionFactory
							.getCurrentSession().createSQLQuery(
								sql)
							.setParameter("login", login)
							.setMaxResults(1)
							.uniqueResult()
							//.setResultTransformer(Transformers.aliasToBean(User.class))
							;
			
			userList =  (List<User>) query.list();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}	
		if (userList.size() > 0)
			return userList.get(0);
		else
			return null;	
*/			
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<String> getUserRoles(Integer userid) {

		List<UserBean> userList = new ArrayList<UserBean>();
		List<String> roleList = new ArrayList<String>();
		
		String sql = "select u.iduser as iduser, u.username as username, u.password as password, "
				+ " r.role as role_name, r.id as role_id "
				+ " from user u "
				+ " left join user_roles ur  "
				+ " on u.iduser = ur.user_id "
				+ " left join roles r "
				+ " on r.id = ur.role_id "
				+ " where u.iduser = :userid ";

		try{
			Query query = sessionFactory
							.getCurrentSession().createSQLQuery(
								sql)
							.setInteger("userid", userid)
							.setResultTransformer(Transformers.aliasToBean(UserBean.class))
							;
			
			userList =  (List<UserBean>) query.list();
 		
	
		for (UserBean user : userList){
			roleList.add(user.getRole_name());
		}
		return roleList;
		
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}		
	}
	
	
	public Integer getPageNo() {
		return pageNo;
	}

	public void setPageNo(Integer pageNo) {
		this.pageNo = pageNo;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getTotal() {
		return total;
	}

	public void setTotal(Integer total) {
		this.total = total;
	}

	public String getSortname() {
		return sortname;
	}

	public void setSortname(String sortname) {
		this.sortname = sortname;
	}

	public String getSortorder() {
		return sortorder;
	}

	public void setSortorder(String sortorder) {
		this.sortorder = sortorder;
	}

	public String getQuerySearch() {
		return querySearch;
	}

	public void setQuerySearch(String querySearch) {
		this.querySearch = querySearch;
	}

	public String getQueryQType() {
		return queryQType;
	}

	public void setQueryQType(String queryQType) {
		this.queryQType = queryQType;
	}


}
