package rs.co.master.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

import rs.co.master.model.Role;

@Entity
@Table(name="user")
public class UserModel  implements Serializable{
	private static final long serialVersionUID = -72322205858532343L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name = "iduser")
	private Integer iduser;
	
	@NotNull
	@Column(name = "username")
	private String username;//login;
	@NotNull
	@Column(name = "password", columnDefinition = "VARCHAR(255)" )
	private String password;
	
	@Column(name = "accountNonExpired", columnDefinition = "TINYINT(1)" )
	private Boolean accountNonExpired;
	@Column(name = "accountNonLocked", columnDefinition = "TINYINT(1)")
	private Boolean accountNonLocked;
	@Column(name = "credentialsNonExpired", columnDefinition = "TINYINT(1)")
	private Boolean credentialsNonExpired;
	@Column(name = "enabled", columnDefinition = "TINYINT(1)")
	private Boolean enabled;
	
	
	@Column(name = "mobilni")
	private String mobilni;
	@Column(name = "adresa")
	private String adresa;
	@Column(name = "telefon")
	private String telefon;
	@Column(name = "email")
	private String email;
	@Column(name = "ime")
	private String ime;
	@Column(name = "prezime")
	private String prezime;

	@Column(name = "isuseradmin", columnDefinition = "TINYINT(1)")
	private Boolean isuseradmin;
	@Column(name = "isvlasnik", columnDefinition = "TINYINT(1)")
	private Boolean isvlasnik;

	public UserModel(){
		super();
		
	}
	public Boolean isCredentialsNonExpired() {
		return credentialsNonExpired;
	}
	public void setCredentialsNonExpired(Boolean credentialsNonExpired) {
		this.credentialsNonExpired = credentialsNonExpired;
	}

	public Integer getIduser() {
		return iduser;
	}

	public void setIduser(Integer iduser) {
		this.iduser = iduser;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Boolean getAccountNonExpired() {
		return accountNonExpired;
	}

	public void setAccountNonExpired(Boolean accountNonExpired) {
		this.accountNonExpired = accountNonExpired;
	}

	public Boolean getAccountNonLocked() {
		return accountNonLocked;
	}

	public void setAccountNonLocked(Boolean accountNonLocked) {
		this.accountNonLocked = accountNonLocked;
	}

	public Boolean getEnabled() {
		return enabled;
	}

	public void setEnabled(Boolean enabled) {
		this.enabled = enabled;
	}

	public String getIme() {
		return ime;
	}

	public void setIme(String ime) {
		this.ime = ime;
	}

	public String getPrezime() {
		return prezime;
	}

	public void setPrezime(String prezime) {
		this.prezime = prezime;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Boolean getCredentialsNonExpired() {
		return credentialsNonExpired;
	}

	
	public String getMobilni() {
		return mobilni;
	}

	public void setMobilni(String mobilni) {
		this.mobilni = mobilni;
	}

	public String getAdresa() {
		return adresa;
	}

	public void setAdresa(String adresa) {
		this.adresa = adresa;
	}

	public String getTelefon() {
		return telefon;
	}

	public void setTelefon(String telefon) {
		this.telefon = telefon;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Boolean getIsuseradmin() {
		return isuseradmin;
	}

	public void setIsuseradmin(Boolean isuseradmin) {
		this.isuseradmin = isuseradmin;
	}

	public Boolean getIsvlasnik() {
		return isvlasnik;
	}

	public void setIsvlasnik(Boolean isvlasnik) {
		this.isvlasnik = isvlasnik;
	}

	public UserModel(Integer iduser, String username, String password,
			Boolean accountNonExpired, Boolean accountNonLocked,
			Boolean credentialsNonExpired, Boolean enabled, String mobilni,
			String adresa, String telefon, String email, String ime,
			String prezime, Boolean isuseradmin, Boolean isvlasnik) {
		super();
		this.iduser = iduser;
		this.username = username;
		this.password = password;
		this.accountNonExpired = accountNonExpired;
		this.accountNonLocked = accountNonLocked;
		this.credentialsNonExpired = credentialsNonExpired;
		this.enabled = enabled;
		this.mobilni = mobilni;
		this.adresa = adresa;
		this.telefon = telefon;
		this.email = email;
		this.ime = ime;
		this.prezime = prezime;
		this.isuseradmin = isuseradmin;
		this.isvlasnik = isvlasnik;
	}


	public UserModel (Integer iduser, String username, String password, String role, Integer role_id){
		super();
		this.iduser = iduser;
		this.username = username;
		this.password = password;
//		this.role.setRole(role); 
//		this.role.setId(role_id); 
	}

	public UserModel(Integer iduser, String username, String password,
			Boolean accountNonExpired, Boolean accountNonLocked,
			Boolean credentialsNonExpired, Boolean enabled, String ime,
			Role role, Integer role_id, String role_name) {
		super();
		this.iduser = iduser;
		this.username = username;
		this.password = password;
		this.accountNonExpired = accountNonExpired;
		this.accountNonLocked = accountNonLocked;
		this.credentialsNonExpired = credentialsNonExpired;
		this.enabled = enabled;
		this.ime = ime;
/*		this.role = role;
		this.role_id = role_id;
		this.role_name = role_name;
*/		
	}

	
	
}
