/**
 * @author Misko 30.05.2013
 * 
 * 
 */

package rs.co.master.dao;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

import rs.co.master.bean.UserRulesBean;
import rs.co.master.model.Role;
import rs.co.master.model.UserRolesModel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

//@Component
@Repository("UserRulesDao")
@Transactional
@EnableTransactionManagement 
public class UserRulesDaoImpl implements UserRulesDao {
	private Integer pageNo;
	private Integer pageSize;
	private Integer total;
	private String sortname;
	private String sortorder;
	private String querySearch;
	private String queryQType;

	private String jsonPage;
	
	@Autowired
	private SessionFactory sessionFactory;

	public UserRulesDaoImpl(SessionFactory sessionFactory) {
		super();
		this.sessionFactory = sessionFactory;
	}
	public UserRulesDaoImpl() {
		super();
		// TODO Auto-generated constructor stub
	}
	public SessionFactory getSessionFactory() {
		return sessionFactory;
	}

	public void setSessionFactory(SessionFactory sessionFactory) {
		this.sessionFactory = sessionFactory;
	}


	public static String getTimeSeparator(Locale locale) {
		String sepValue = ":";

		DateFormat dateFormatter = DateFormat.getTimeInstance(DateFormat.SHORT,
				locale);
		DateFormatSymbols dfs = new DateFormatSymbols(locale);
		Date now = new Date();

		String[] amPmStrings = dfs.getAmPmStrings();
		String localeTime = dateFormatter.format(now);
		// remove the am pm string if they exist
		for (int i = 0; i < amPmStrings.length; i++) {
			localeTime = localeTime.replace(dfs.getAmPmStrings()[i], "");
		}

		// search for the character that isn't a digit.
		for (int currentIndex = 0; currentIndex < localeTime.length(); currentIndex++) {
			if (!(Character.isDigit(localeTime.charAt(currentIndex)))) {
				sepValue = localeTime.substring(currentIndex, currentIndex + 1);
				break;
			}
		}

		return sepValue;
	}


	private UserRolesModel convertToModel(UserRulesBean bean) {
		UserRolesModel model = new UserRolesModel(
				bean.getIduser(), 
				bean.getRole_id()
							);
		return model;

	}


	private UserRulesBean convertToBean(UserRolesModel csm) {
	
		UserRulesBean csb = new UserRulesBean(
						csm.getIduser(), 
						csm.getRole_id()
						);				
		return csb;

	}
/*
	private List<UserRulesBean> convertToBeanList(List<UserRolesModel> csModel) {
		List<UserRulesBean> listcsBean = new ArrayList<UserRulesBean>();
		for (UserRolesModel csm : csModel) {
			UserRulesBean csb =  convertToBean(csm);
			listcsBean.add(csb);
		}
		return listcsBean;
	}
*/

	@SuppressWarnings("unchecked")
	public List<UserRolesModel> listUserRolesModel() {

		List<UserRolesModel> csModel;

		String hql = "from UserRolesModel ";
		Query query = sessionFactory.getCurrentSession().createQuery(hql);

		csModel = (List<UserRolesModel>) query.list();

		return csModel;
	}

	@SuppressWarnings("unchecked")
	public List<UserRulesBean> listUserRules(Integer user_id){

		List<UserRulesBean> csBean;

		String hql = "select iduser as iduser, role_id as Role_id from UserRolesModel "
				+ "	where user_id = :user_id" ;
		Query query = sessionFactory.getCurrentSession().createQuery(hql)
				.setInteger("user_id", user_id)
				.setResultTransformer(Transformers
				.aliasToBean(UserRulesBean.class));;

		csBean = (List<UserRulesBean>) query.list();

		return csBean;
	}
	
	@SuppressWarnings("rawtypes")
	public List getSveUserove() throws Exception {
		String hql = "from UserRolesModel";
		Query query = sessionFactory.getCurrentSession().createQuery(hql);
		return query.list();
	}

	public String getJsonByPage(Integer user_id, HttpServletRequest upit) {
		// HttpServletRequest request = ServletActionContext.getRequest();
		pageNo = Integer.parseInt(upit.getParameter("page"));
		pageSize = Integer.parseInt(upit.getParameter("rp"));
		sortname = (upit.getParameter("sortname"));
		sortorder = upit.getParameter("sortorder");
		querySearch = upit.getParameter("query");
		queryQType = upit.getParameter("qtype");

		try {

			jsonPage = findByPageNo(user_id, pageNo, pageSize);
			return jsonPage;

		} catch (Exception e) {
			e.printStackTrace();
			return "errorInfo " + e.toString();
		}
	}
	
	@SuppressWarnings("unchecked")
	public String findByPageNo(Integer user_id, int pageNo, int pageSize) {
/*
Integer user_id, Integer role_id, String role,
			String username, Boolean accountNonExpired,
			Boolean accountNonLocked, Boolean credentialsNonExpired,
			Boolean enabled, String ime, String prezime, Boolean canGrant
 * 
 * */
		String sql = 
				" SELECT t.username as username, r.id as Role_id, r.role as Role, r.cangrant as CanGrant, "
				+ " t.ime as ime, t.prezime as prezime," 
				+ " t.accountNonExpired as accountNonExpired, t.accountNonLocked as accountNonLocked, "
				+ " t.credentialsNonExpired as credentialsNonExpired, t.enabled as enabled "
				+ " FROM user t, roles r, user_roles ur"
				+ " WHERE t.user_id = ur.user_id AND r.id = ur.role_id AND t.iduser = :iduser "
				;
		
		if (null != queryQType && queryQType != "" && querySearch != null
				&& querySearch != "")
			sql = sql + " and  " + queryQType + " like '%" + querySearch
					+ "%' ";

		if (null != sortname && sortname != "" && null != sortorder
				&& sortorder != "")
			sql = sql + " order by " + sortname + " " + sortorder;

		Query query;
		try {
			query = sessionFactory.getCurrentSession().createSQLQuery(sql)
					.setInteger("iduser", user_id)
					;
			
			query.setResultTransformer(Transformers
					.aliasToBean(UserRulesBean.class));

			this.total = query.list().size();
			if (null == this.total)
				this.total = 0;

			List<UserRulesBean> tmpList;// = (List<SpisakOdvageBean>)
											// query.list();

			query.setMaxResults(pageSize);
			query.setFirstResult((pageNo - 1) * pageSize);
			tmpList = (List<UserRulesBean>) query.list();


			Gson gson = new GsonBuilder().setDateFormat("dd/MM/yyyy").create();
			jsonPage = gson.toJson("");

			return jsonPage;

		} catch (Exception e) {
			e.printStackTrace();
			return "errorInfo " + e.toString();
		}
		
	}
	
	@Override
	@Transactional
	public void addUser(UserRulesBean userbean) throws Exception {
		try {
			UserRolesModel u = new UserRolesModel();
			
			u = convertToModel(userbean);
			if (null == getRuleForUser(userbean.getIduser(), userbean.getRole_id())){
				sessionFactory.getCurrentSession().save(u);
				
			} else {
				sessionFactory.getCurrentSession().saveOrUpdate(u);
				
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		} 

	}

	public void deleteUser(Integer iduser, Integer role_id) {
		sessionFactory
				.getCurrentSession()
				.createSQLQuery(
						"DELETE FROM user_roles WHERE user_id =:iduser AND role_id =:role_id"
								)
					.setInteger("iduser", iduser)
					.setInteger("role_id", role_id)
					.executeUpdate();
	}


	public UserRulesBean getRuleForUser(Integer iduser, Integer role_id) {
		if ((iduser == null) )//|| (iduser == 0)
			return null;

		UserRulesBean tmpUser = null;

		String sql = "from UserRolesModel  where user_id = :iduser and role_id = :role_id ";
		try {
			tmpUser = (UserRulesBean) sessionFactory.getCurrentSession()
					.createQuery(sql)
					.setInteger("iduser", iduser)
					.setInteger("role_id", role_id)
					.setResultTransformer(Transformers
							.aliasToBean(UserRulesBean.class))
					.uniqueResult()
					;

		} catch (Exception e) {
			// log.error("Error occurred while getting tasks by project user_id : "+e.getMessage());
			e.printStackTrace();
		}
		return tmpUser;

	}
	
	public UserRulesBean findUserRole(Integer iduser, Integer role_id) {
		if (iduser == null)
			return null;

		UserRolesModel tmpUser = null;

		String sql = "from UserRolesModel  where user_id = :iduser and role_id = :role_id ";
		try {
			tmpUser = (UserRolesModel) sessionFactory.getCurrentSession()
					.createQuery(sql)
					.setInteger("iduser", iduser)
					.setInteger("role_id", role_id)
					.uniqueResult();
			if(tmpUser == null)
				return null;
					} catch (Exception e) {
			// log.error("Error occurred while getting tasks by project user_id : "+e.getMessage());
			e.printStackTrace();
			tmpUser = new UserRolesModel();
		}
		return convertToBean(tmpUser);
	}

	public UserRulesBean findUser(String username) {
		if (username == null)
			return null;

		UserRolesModel tmpUser = null;

		String sql = "from UserRolesModel  where username = :username ";
		try {
			tmpUser = (UserRolesModel) sessionFactory.getCurrentSession()
					.createQuery(sql)
					.setString("username", username)
					.uniqueResult();

			if (null == tmpUser) {
				return null;//tmpUser = new User();
			}
		} catch (Exception e) {
			// log.error("Error occurred while getting tasks by project user_id : "+e.getMessage());
			e.printStackTrace();
			tmpUser = new UserRolesModel();
		}
		return convertToBean(tmpUser);

	}


	public boolean hasUser(Integer user_id) {
		Integer tmp;
		Boolean result = false;
		/* ne koristi se */

		String sql = "select count(cm.user_id) as user_id from User cm where cm.user_id=:user_id";
		try {
			tmp = (Integer) sessionFactory.getCurrentSession().createQuery(sql)
					.setInteger("user_id", user_id).uniqueResult();
			if (tmp > 0) {
				result = true;
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;

	}
	
	private Session getCurrentSession() {
		return sessionFactory.getCurrentSession();
	}

	public Role getRole(int id) {
		Role role = (Role) getCurrentSession().load(Role.class, id);
		return role;
	}

	@SuppressWarnings("unchecked")
	public List<Role> listRole() {

		List<Role> csRole;

		String hql = "from Role " + " order by role ";
		Query query = sessionFactory.getCurrentSession().createQuery(hql);

		csRole = (List<Role>) query.list();

		return csRole;
	}

	public Integer getPageNo() {
		return pageNo;
	}

	public void setPageNo(Integer pageNo) {
		this.pageNo = pageNo;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getTotal() {
		return total;
	}

	public void setTotal(Integer total) {
		this.total = total;
	}

	public String getSortname() {
		return sortname;
	}

	public void setSortname(String sortname) {
		this.sortname = sortname;
	}

	public String getSortorder() {
		return sortorder;
	}

	public void setSortorder(String sortorder) {
		this.sortorder = sortorder;
	}

	public String getQuerySearch() {
		return querySearch;
	}

	public void setQuerySearch(String querySearch) {
		this.querySearch = querySearch;
	}

	public String getQueryQType() {
		return queryQType;
	}

	public void setQueryQType(String queryQType) {
		this.queryQType = queryQType;
	}


}
