package rs.co.master.model;

import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
//import javax.persistence.OneToOne;
import javax.persistence.Table;

import rs.co.master.dao.UserModel;

@Entity
@Table(name = "roles")
public class Role {

	@Id
	@GeneratedValue
	private Integer id;

	private String role;
	
	private Boolean CanGrant;
	private String  Description;
	

	@OneToMany(cascade = CascadeType.ALL)
	@JoinTable(name = "user_roles", joinColumns = { @JoinColumn(name = "role_id", referencedColumnName = "id") }, 
			inverseJoinColumns = { @JoinColumn(name = "user_id", referencedColumnName = "iduser") })
	private Set<UserModel> userRoles;

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getRole() {
		return role;
	}

	public void setRole(String role) {
		this.role = role;
	}

	public Set<UserModel> getUserRoles() {
		return userRoles;
	}

	public void setUserRoles(Set<UserModel> userRoles) {
		this.userRoles = userRoles;
	}

	public Boolean getCanGrant() {
		return CanGrant;
	}

	public void setCanGrant(Boolean canGrant) {
		CanGrant = canGrant;
	}

	public String getDescription() {
		return Description;
	}

	public void setDescription(String description) {
		Description = description;
	}

	public Role() {
		super();
		// TODO Auto-generated constructor stub
	}

	public Role(Integer id, String role, Boolean canGrant, String description,
			Set<UserModel> userRoles) {
		super();
		this.id = id;
		this.role = role;
		CanGrant = canGrant;
		Description = description;
		this.userRoles = userRoles;
	}

}
