package rs.co.master.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import rs.co.master.bean.UserRulesBean;
import rs.co.master.dao.UserRulesDao;
import rs.co.master.model.Role;

/**
 * Status predmeta
 * 
 * @author Misko
 * 05.09.2013
 */

@Repository("UserRulesService")
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
public class UserRulesServiceImpl implements UserRulesService{
	@Autowired
	private UserRulesDao userRulesDao;
	
	public UserRulesServiceImpl() {
		super();
		// TODO Auto-generated constructor stub
	}

	public UserRulesServiceImpl(UserRulesDao userRulesDao) {
		super();
		this.userRulesDao = userRulesDao;
	}

	public UserRulesDao getUserRulesDao() {
		return userRulesDao;
	}

	public void setUserRulesDao(UserRulesDao userRulesDao) {
		this.userRulesDao = userRulesDao;
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED, readOnly = false)
	public void addUser(UserRulesBean User) throws Exception  {
		userRulesDao.addUser(User);
	}

	@Override
	public void deleteUser(Integer iduser, Integer role_id) {
		userRulesDao.deleteUser(iduser, role_id);
	}

	@Override
	public boolean hasUser(Integer iduser) {
		return userRulesDao.hasUser(iduser);
	}
	
	@Override
	public List<UserRulesBean> listUserRules(Integer iduser){
		return userRulesDao.listUserRules(iduser);
	}
	
	
	@Override
	public UserRulesBean getRuleForUser(Integer iduser, Integer role_id) {
		return userRulesDao.getRuleForUser(iduser, role_id);
	}

	@Override
	public UserRulesBean findUser(String username) {
		return userRulesDao.findUser(username);
	}

	@Override
	public String getJsonByPage(Integer iduser, HttpServletRequest upit){
		return userRulesDao.getJsonByPage(iduser, upit);
	}
	
	@Override
	public UserRulesBean findUserRole(Integer iduser, Integer role_id){
		return userRulesDao.findUserRole(iduser, role_id);
	}

	@Override
	public Role getRole(int id) {
		return userRulesDao.getRole(id);
	}

	@Override
	public List<Role>listRole() {
		return userRulesDao.listRole();
	}
}
