package rs.co.master.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import rs.co.master.bean.UserBean;
import rs.co.master.dao.UserDao;
import rs.co.master.dao.UserModel;

/**
 * Status predmeta
 * 
 * @author Misko
 * 05.09.2013
 */

@Repository("UserService")
//@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
public class UserServiceImpl implements UserService{
	@Autowired
	private UserDao userDao;

	public UserDao getUserDao() {
		return userDao;
	}

	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

	public UserServiceImpl(UserDao userDao) {
		super();
		this.userDao = userDao;
	}

	public UserServiceImpl() {
		super();
		// TODO Auto-generated constructor stub
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED, readOnly = false)
	public void addUser(UserBean User)  throws Exception{
		userDao.addUser(User);
	}

	@Override
	public void deleteUser(Integer Iduser) {
		userDao.deleteUser(Iduser);
	}

	@Override
	public boolean hasUser(Integer Iduser) {
		return userDao.hasUser(Iduser);
	}

	@Override
	public List<UserBean> listUser() {
		return userDao.listUser();
	}

	@Override
	public UserBean getUser(Integer Iduser) {
		return userDao.getUser(Iduser);
	}

	@Override
	public UserBean findUser(String username) {
		return userDao.findUser(username);
	}	
	@Override
	public Boolean isAdmin(Integer iduser) {
		return userDao.isAdmin(iduser);
	}
	
	@Override
	public UserBean getUser(String login) {
		return userDao.getUser(login);
	}

}
